<?php
/**
 *  Dokan Dashboard Orders Template
 *
 *  Load order related template
 *
 *  @since 2.4
 */
?>

<?php do_action( 'dokan_dashboard_wrap_start' ); ?>

    <div class="dokan-dashboard-wrap">

        <?php

            /**
             *  dokan_dashboard_content_before hook
             *
             *  @hooked get_dashboard_side_navigation
             *
             *  @since 2.4
             */
            do_action( 'dokan_dashboard_content_before' );
            do_action( 'dokan_rma_reqeusts_before' );

        ?>

        <div class="dokan-dashboard-content dokan-orders-content">

            <?php

                /**
                 *  dokan_rma_request_content_inside_before hook
                 *
                 *  @hooked show_seller_enable_message
                 *
                 *  @since 2.4
                 */
                do_action( 'dokan_rma_request_content_inside_before' );
            ?>


            <article class="dokan-rma-request-area">
                <header class="dokan-dashboard-header">
                    <h1 class="entry-title"><?php _e( 'Return Requests', 'dokan' ); ?></h1>
                </header><!-- .entry-header -->

                <?php dokan_warranty_request_listing_status_filter(); ?>

                <table class="dokan-table table table-striped rma-request-listing-table">
                    <thead>
                        <tr>
                            <th><?php _e( 'Details', 'dokan' ); ?></th>
                            <th><?php _e( 'Products', 'dokan' ); ?></th>
                            <th><?php _e( 'Type', 'dokan' ); ?></th>
                            <th><?php _e( 'Status', 'dokan' ); ?></th>
                            <th><?php _e( 'Last Updated', 'dokan' ); ?></th>
                            <th></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php if ( $requests ) { ?>
                            <?php
                            foreach ( $requests as $request ) {
                                $is_order_deleted = $request['is_order_deleted'];
                                ?>
                                <tr>
                                    <td class="details column-primary">
                                        <?php

                                        if ( $is_order_deleted ) {

                                            // deleted order show
                                            // deleted order show
                                            printf(
											// translators: 1: Request ID 2: Customer name 3: Order ID
                                                __( '#%1$s by %2$s on <strong>Order <br/> %3$s</strong>', 'dokan' ), $request['id'],
                                                $request['customer']['name'],
                                                $request['order_id']
                                            );
                                        } else {
											if ( current_user_can( 'dokan_view_order' ) ) {
												// translators: 1: Return Request URL 2: Return request ID 3: Customer name 4: Order link
												$order_link = '<a href="' . wp_nonce_url( add_query_arg( [ 'order_id' => $request['order_id'] ], dokan_get_navigation_url( 'orders' ) ), 'dokan_view_order' ) . '"><strong>' . sprintf( __( 'Order %s', 'dokan' ), esc_attr( $request['order_id'] ) ) . '</strong></a>';
											} else {
                                                // translators: 1: Return Request URL 2: Return request ID 3: Customer name 4: Order link
												$order_link = '<strong>' . sprintf( __( 'Order %s', 'dokan' ), esc_attr( $request['order_id'] ) ) . '</strong>';
											}
											// translators:  1: Return Request URL 2: Return request ID 3: Customer name 4: Order link
											printf( __( '<a href="%1$s">#%2$s</a> by %3$s on %4$s', 'dokan' ), add_query_arg( [ 'request' => $request['id'] ], dokan_get_navigation_url( 'return-request' ) ), number_format_i18n( $request['id'] ), $request['customer']['name'], $order_link );
											?>

                                        <div class="row-actions">
                                            <span class="edit">
                                                <a href="<?php echo add_query_arg( [ 'request' => $request['id'] ], dokan_get_navigation_url( 'return-request' ) ); ?>" class="request-manage"><?php _e( 'Manage', 'dokan' ); ?></a>
                                            </span> |
                                            <span class="delete">
                                                <a href="
                                                <?php
                                                echo wp_nonce_url(
                                                    add_query_arg(
                                                        [
															'action' => 'dokan-delete-rma-request',
															'request_id' => $request['id'],
														], dokan_get_navigation_url( 'return-request' )
                                                    ), 'dokan-delete-rma-request'
                                                );
												?>
                                                            " class="request-delete"><?php _e( 'Delete', 'dokan' ); ?></a>
                                            </span>
                                        </div>

                                        <button type="button" class="toggle-row"></button>
                                        <?php } ?>
                                    </td>
                                    <td data-title="<?php _e( 'Products', 'dokan' ); ?>">
                                        <?php
                                            $product_list = [];

										foreach ( $request['items'] as $item ) {
											$product_list[] = '<a href="' . $item['url'] . '">' . $item['title'] . '</a> <strong>x ' . $item['quantity'] . '</strong>';
										}

                                            echo implode( ', ', $product_list );
                                        ?>
                                    </td>
                                    <td data-title="<?php _e( 'Type', 'dokan' ); ?>">
                                        <?php echo dokan_warranty_request_type( $request['type'] ); ?>
                                    </td>
                                    <td class="<?php echo $is_order_deleted ? 'dokan_rma_list_order deleted' : 'dokan_rma_list_order'; ?>" data-title="<?php _e( 'Status', 'dokan' ); ?>">
                                        <?php echo dokan_warranty_request_status( $request['status'] ); ?>
                                    </td>
                                    <td data-title="<?php _e( 'Last Updated', 'dokan' ); ?>">
                                        <?php echo date_i18n( get_option( 'date_format' ), strtotime( $request['created_at'] ) ); ?>
                                    </td>
                                    <?php if ( ! $is_order_deleted ) { ?>
                                        <td data-title="<?php esc_attr_e( 'View', 'dokan' ); ?>">
                                            <a class="dokan-btn dokan-btn-default dokan-btn-sm tips" href="<?php echo add_query_arg( [ 'request' => $request['id'] ], dokan_get_navigation_url( 'return-request' ) ); ?>" data-toggle="tooltip" title="<?php esc_html_e( 'View', 'dokan' ); ?>" data-placement="top" title="%s"><i class="far fa-eye">&nbsp;</i></a>
                                        </td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } else { ?>
                            <tr>
                                <td colspan="6">
                                    <?php _e( 'No request found', 'dokan' ); ?>
                                </td>
                            </tr>
                        <?php } ?>

                    </tbody>
                </table>

                <?php echo $pagination_html; ?>
            </article>


            <?php

                /**
                 *  dokan_order_content_inside_after hook
                 *
                 *  @since 2.4
                 */
                do_action( 'dokan_rma_request_content_inside_after' );
            ?>

        </div> <!-- #primary .content-area -->

        <?php

            /**
             *  dokan_dashboard_content_after hook
             *  dokan_rma_reqeusts_after hook
             *
             *  @since 2.4
             */
            do_action( 'dokan_dashboard_content_after' );
            do_action( 'dokan_rma_reqeusts_after' );

        ?>

    </div><!-- .dokan-dashboard-wrap -->

<?php do_action( 'dokan_dashboard_wrap_end' ); ?>
